/*******************************************************
Filename		:  	DW_char_select_wme.sql
Release 		:  	STORET c2.0/e2.0, C2.0.1, e2.0.1
SIR			:  	1504, 1553, 1563, 1570
Description		:  	Creates a web page section that allows the user to select 
				characteristics to query Stations or Results. 
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	June 19, 2003
                        	08/08/2003 - Chg to display alias list based on result type. -CT
				08/22/2003 - Updated caption; added STATION_FLAG -JW
                        09/26/2003 - Added code to display char display name if char_isn is passed in. -CT
                        11/20/2003 - SIR 1570 - Changed title of Alias Type drop down; changed "STORET DEFAULT" to                             "Characteristic Name".  B. Norris
Comments		:  	Code was extracted from dw_result_criteria_geo.  Called from other procedures.
**********************************************************/
spool DW_char_select_wme.log

SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_char_select_wme(
tabstart in number,
char_isn in number DEFAULT 0, 
result_type char default 'REGULAR',
station_flag char default 'OFF') AS

--used to generate char alias type list 
CURSOR calias IS
SELECT pk_isn, char_alias_type_name 
FROM LU_CHAR_ALIAS_TYPE
WHERE char_alias_type_category = 'NT'
ORDER BY pk_isn;

--used to generate char alias type list for Bio results
CURSOR calias_bio IS
SELECT pk_isn, char_alias_type_name 
FROM LU_CHAR_ALIAS_TYPE
WHERE char_alias_type_category IS NOT NULL 
ORDER BY pk_isn;

--used to generate selected char list based on the char_isn passed in
CURSOR c_Char IS
	SELECT display_name, pk_isn
		FROM DI_CHARACTERISTIC
		WHERE pk_isn = char_isn;

v_prepop  boolean := TRUE;

BEGIN
htp.print('
<h4>Characteristic</h4>');
IF station_flag = 'ON' THEN
	htp.print('<center>Find Stations with at least one reported value of the selected Characteristics</center>');
END IF;
htp.print('
<table BORDER COLS=1 WIDTH="100%" >
<tr>
<td align="center">
<center>Use the Characteristic Search to create a list of up to 50 Characteristics</center>
<br>
<b>Characteristic Search &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp 
&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp Search By&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp </b>
<BR>
<font face= "Courier, monospace">
<input type=hidden name="v_char_names">
<input type="text" name="as_char" tabindex='|| to_char(tabstart) ||' size="20" maxlength="20" style="font-size: 10pt; font-family: Courier, monospace">
&nbsp &nbsp &nbsp &nbsp &nbsp
<select name="as_char_alias_type" tabindex='|| to_char(tabstart+1) ||' size="1" style="font-size: 10pt; font-family: Courier, monospace" >
<option value=0>CHARACTERISTIC NAME</option>');
IF result_type = 'BIOLOGICAL' THEN
  FOR alias IN calias_bio LOOP
       htp.formSelectOption(alias.char_alias_type_name, cattributes => 'VALUE='||alias.pk_isn);
  END LOOP;
ELSE
  FOR alias IN calias LOOP
      htp.formSelectOption(alias.char_alias_type_name, cattributes => 'VALUE='||alias.pk_isn);
  END LOOP;
END IF;
htp.print('</font></SELECT>
<BR>
<font face="Arial">
<input type="button" tabindex='|| to_char(tabstart+2) ||' value="Search"  onclick="openWin(''char_alias'')" title="Opens a popup window for characteristic selection">
<input checked type="checkbox" name="taxon_filter" tabindex='|| to_char(tabstart+3) ||' value="ON" >Hide Taxonomic Names
<BR><BR><font face= "Courier, monospace">
<select multiple size="10" name="char_list" style="font-size: 10pt; font-family: Courier, monospace" >
<option>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp Characteristic Name</option>
<option value="dummy">___________________________________________________________</option>
');
IF (v_prepop = TRUE) AND (char_isn > 0) THEN
	FOR cv_char IN c_Char LOOP
		HTP.FormSelectOption(cv_char.display_name,cattributes => 'value ='||cv_char.pk_isn);
	END LOOP;
      v_prepop := FALSE;
END IF;
htp.print('
</select></font>
<BR>
<input type="button" tabindex='|| to_char(tabstart+4) ||' value="Clear Selected" onclick="javascript:deleteSelectedFromCharList();" title="Remove highlighted Characteristics from Selected List">
<input type="button" tabindex='|| to_char(tabstart+5) ||' value="Clear All" onclick="javascript:deleteAllFromCharList();" title="Remove all Characteristics from the Selected List">
</font>
</td>
</tr>
</table>');

END;
/
SHOW ERRORS;


spool off;